
import React from 'react';
import { ServerIcon, GlobeAltIcon, ShieldCheckIcon, ZapIcon } from './constants';

const LOGO_URL = "./jax-logo.png";

interface FeatureCardProps {
  icon: React.ReactNode;
  title: string;
  description: string;
}

const FeatureCard: React.FC<FeatureCardProps> = ({ icon, title, description }) => (
  <div className="bg-brand-dark-secondary p-6 rounded-lg border border-gray-700/50 transition-all duration-300 hover:border-brand-blue hover:shadow-2xl hover:shadow-brand-blue/10 transform hover:-translate-y-1">
    <div className="flex items-center justify-center h-12 w-12 rounded-lg bg-brand-blue/10 text-brand-blue mb-4">
      {icon}
    </div>
    <h3 className="text-xl font-bold text-brand-light mb-2">{title}</h3>
    <p className="text-brand-gray">{description}</p>
  </div>
);

const App: React.FC = () => {
  const navLinks = ["About", "Services", "Partners", "Contact", "Speedtest", "Looking Glass"];

  return (
    <div className="min-h-screen bg-brand-dark font-sans">
      {/* Header */}
      <header className="sticky top-0 z-50 bg-brand-dark/80 backdrop-blur-sm border-b border-gray-800">
        <nav className="container mx-auto px-6 py-4 flex justify-between items-center">
          <img src={LOGO_URL} alt="JAX Logo" className="h-10 rounded-md" />
          <div className="hidden md:flex items-center space-x-8">
            {navLinks.map((link) => (
              <a key={link} href={`#${link.toLowerCase()}`} className="text-brand-gray hover:text-brand-light transition-colors duration-200">
                {link}
              </a>
            ))}
          </div>
          <button className="hidden md:inline-block bg-brand-blue hover:bg-opacity-90 text-white font-semibold py-2 px-4 rounded-lg transition-transform duration-200 transform hover:scale-105">
            Get Connected
          </button>
          <div className="md:hidden">
            <button className="text-brand-light">
              <svg xmlns="http://www.w3.org/2000/svg" className="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 6h16M4 12h16m-7 6h7" />
              </svg>
            </button>
          </div>
        </nav>
      </header>

      <main>
        {/* Hero Section */}
        <section className="relative text-center py-20 md:py-32 px-6 overflow-hidden">
          <div className="absolute inset-0 bg-grid-gray-800/20 [mask-image:linear-gradient(to_bottom,white_5%,transparent_90%)]"></div>
          <div className="absolute inset-0 bg-gradient-to-b from-brand-dark via-brand-dark to-transparent opacity-80"></div>
          <div className="relative z-10 container mx-auto">
            <img src={LOGO_URL} alt="JAX Logo" className="h-24 md:h-32 mx-auto mb-8 rounded-lg shadow-2xl" />
            <h1 className="text-4xl md:text-6xl font-extrabold text-brand-light tracking-tight mb-4">
              Jambi Access <span className="text-brand-blue">Exchange</span>
            </h1>
            <p className="max-w-3xl mx-auto text-lg md:text-xl text-brand-gray mb-8">
              PT Global Digital Core menghadirkan Internet Exchange netral yang memperkuat fondasi data Jambi dan menumbuhkan ekosistem digital yang lebih terhubung, cepat, dan andal.
            </p>
            <div className="flex justify-center space-x-4">
              <a href="#contact" className="bg-brand-blue hover:bg-opacity-90 text-white font-bold py-3 px-8 rounded-lg transition-transform duration-200 transform hover:scale-105">
                Join JAX
              </a>
              <a href="#about" className="bg-brand-dark-secondary border border-gray-700 hover:border-gray-500 text-brand-light font-bold py-3 px-8 rounded-lg transition-colors duration-200">
                Learn More
              </a>
            </div>
          </div>
        </section>
{/* Speedtest Section */}
<section id="speedtest" className="py-20 px-6 bg-brand-dark-secondary">
  <div className="container mx-auto">
    <div className="text-center max-w-2xl mx-auto mb-8">
      <h2 className="text-3xl font-bold tracking-tight text-brand-light">
        JAX Speedtest
      </h2>
      <p className="mt-4 text-brand-gray">
        Uji langsung kualitas koneksi yang melewati Jambi Access Exchange (JAX).
        Hasil pengukuran ini membantu memastikan performa akses lokal dan interkoneksi
        antar anggota tetap optimal.
      </p>
    </div>

    <div className="w-full max-w-5xl mx-auto">
      <div className="rounded-2xl overflow-hidden shadow-xl bg-black/40 border border-brand-border min-h-[450px]">
        <iframe
          src="https://speedtest.jax.net.id"
          className="w-full h-[55vh] min-h-[450px] border-0"
          loading="lazy"
          title="JAX Speedtest"
        />
      </div>
    </div>
  </div>
</section>
{/* Looking Glass Section */}
<section id="looking-glass" className="py-20 px-6">
  <div className="container mx-auto">
    <div className="text-center max-w-2xl mx-auto mb-8">
      <h2 className="text-3xl font-bold tracking-tight text-brand-light">
        JAX Looking Glass
      </h2>
      <p className="mt-4 text-brand-gray">
        Pantau routing, BGP, dan path koneksi dari perspektif JAX. 
        Tools ini memudahkan anggota, engineer, dan NOC untuk menganalisa jalur 
        dan troubleshooting interkoneksi secara transparan.
      </p>
    </div>

    <div className="w-full max-w-5xl mx-auto">
      <div className="rounded-2xl overflow-hidden shadow-xl bg-brand-dark-secondary border border-brand-border min-h-[450px]">
        <iframe
          src="https://lg.jax.net.id"
          className="w-full h-[100vh] min-h-[450px] border-0"
          loading="lazy"
          title="JAX Looking Glass"
        />
      </div>
    </div>
  </div>
</section>

        {/* About Section */}
        <section id="about" className="py-20 px-6 bg-brand-dark-secondary">
          <div className="container mx-auto grid md:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold tracking-tight text-brand-light mb-4">Jambi Solid untuk Akses Tanpa Batas</h2>
              <p className="text-brand-gray mb-4">
                Jambi Access Exchange (JAX) adalah pusat saraf yang mendorong percepatan transformasi digital di Jambi. Berdiri sebagai titik pertukaran netral, kami menyediakan fondasi yang sangat kuat bagi Penyedia Layanan Internet (ISP), penyedia konten, dan perusahaan besar untuk melakukan pertukaran lalu lintas (traffic) secara efisien, berbiaya rendah, dan optimal.
              </p>
              <p className="text-brand-gray">
                Our mission is to keep local traffic local, reducing latency, improving speeds, and creating a resilient digital foundation for the entire region. By integrating with Kominfo and local ISPs, JAX is the central hub for a stronger, faster, and more reliable internet experience in Jambi.
              </p>
            </div>
            <div className="flex justify-center">
                <img src="./peta-jambi.png" alt="Network infrastructure" className="rounded-lg shadow-xl" />
            </div>
          </div>
        </section>

        {/* Services Section */}
        <section id="services" className="py-20 px-6">
          <div className="container mx-auto">
            <div className="text-center max-w-2xl mx-auto mb-12">
              <h2 className="text-3xl font-bold tracking-tight text-brand-light">Our Core Services</h2>
              <p className="mt-4 text-brand-gray">We provide the essential infrastructure for seamless and high-performance connectivity.</p>
            </div>
            <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
              <FeatureCard 
                icon={<GlobeAltIcon className="w-6 h-6" />}
                title="Public Peering"
                description="Exchange traffic directly with other members over a shared, high-speed fabric, improving performance and reducing transit costs."
              />
              <FeatureCard 
                icon={<ServerIcon className="w-6 h-6" />}
                title="Private Interconnect"
                description="Establish dedicated, private connections for high-volume traffic exchange, ensuring security and guaranteed bandwidth."
              />
              <FeatureCard 
                icon={<ShieldCheckIcon className="w-6 h-6" />}
                title="Enhanced Security"
                description="A secure and monitored environment to protect member traffic, ensuring network integrity and reliability."
              />
              <FeatureCard
                icon={<ZapIcon className="w-6 h-6" />}
                title="Low Latency Access"
                description="Keep local traffic within Jambi, drastically reducing latency for users accessing local content and services."
              />
            </div>
          </div>
        </section>

        {/* Partners Section */}
{/* Partners Section */}
<section id="partners" className="py-20 px-6 bg-jax-navy-gray">
  <div className="container mx-auto text-center">
    <h2 className="text-3xl font-bold text-jax-cloud mb-4">
      Integrated with Key Partners
    </h2>

    <p className="text-jax-steel mb-12 max-w-2xl mx-auto">
      We collaborate with regulatory bodies, NAPs, and the local internet ecosystem to strengthen digital infrastructure in Jambi.
    </p>

    <div className="flex flex-wrap justify-center items-center gap-10 md:gap-16">
      
      {/* Item */}
      <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-kominfo.png"
          alt="aksata Logo"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">Goverment Partner</p>
      </div>


      <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-aksata.png"
          alt="aksata Logo"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">ISP Partner</p>
      </div>

      <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-thc.png"
          alt="thc Logo"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">NAP</p>
      </div>

      <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="https://data.pram.id/logo-zanex.png"
          alt="Zanex Logo"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">SI</p>
      </div>

      <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-bvs.png"
          alt="Logo BVS"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">ISP Partner</p>
      </div>

      <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-flashnet.png"
          alt="Logo Flashnet"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">ISP Partner</p>
      </div>
      <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logosem-net.92fcba35.png"
          alt="Logo semnet"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">ISP Partner</p>
      </div>
        <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-cdi.png"
          alt="Logo semnet"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">DC Partner</p>
      </div>
        <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-edgenext.png"
          alt="Logo edgenext"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">CDN Partner</p>
      </div>
        <div className="flex flex-col items-center hover:scale-105 transition">
        <img
          src="./logo-pandi.png"
          alt="Logo pandi"
          className="h-20 opacity-80 hover:opacity-100 transition"
        />
        <p className="mt-3 font-semibold text-jax-steel">Penyedia Domain</p>
      </div>
    </div>
  </div>
</section>


      </main>

      {/* Footer */}
      <footer id="contact" className="bg-brand-dark-secondary border-t border-gray-800">
        <div className="container mx-auto px-6 py-8">
          <div className="md:flex md:justify-between">
            <div className="mb-6 md:mb-0">
              <img src={LOGO_URL} alt="JAX Logo" className="h-10 rounded-md mb-2" />
              <p className="text-brand-gray">Jambi Access Exchange</p>
              <p className="text-sm text-gray-500">by PT GLOBAL DIGITAL CORE</p>
            </div>
            <div className="grid grid-cols-2 sm:grid-cols-3 gap-8">
              <div>
                <h2 className="mb-4 text-sm font-semibold text-brand-light uppercase">Resources</h2>
                <ul className="text-brand-gray space-y-2">
                  <li><a href="#" className="hover:underline">Peering Policy</a></li>
                  <li><a href="#" className="hover:underline">Documentation</a></li>
                </ul>
              </div>
              <div>
                <h2 className="mb-4 text-sm font-semibold text-brand-light uppercase">Follow us</h2>
                <ul className="text-brand-gray space-y-2">
                  <li><a href="#" className="hover:underline">LinkedIn</a></li>
                  <li><a href="#" className="hover:underline">Twitter</a></li>
                </ul>
              </div>
              <div>
                <h2 className="mb-4 text-sm font-semibold text-brand-light uppercase">Legal</h2>
                <ul className="text-brand-gray space-y-2">
                  <li><a href="#" className="hover:underline">Privacy Policy</a></li>
                  <li><a href="#" className="hover:underline">Terms & Conditions</a></li>
                </ul>
              </div>
            </div>
          </div>
          <hr className="my-6 border-gray-700 sm:mx-auto" />
          <div className="text-center text-sm text-brand-gray">
            © {new Date().getFullYear()} PT GLOBAL DIGITAL CORE. All Rights Reserved.
          </div>
        </div>
      </footer>
    </div>
  );
}

export default App;
